import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function seedPlans() {
  console.log('🌱 Seeding plans...');

  const plans = [
    {
      name: 'trial',
      displayName: 'Trial',
      priceMonthly: null,
      priceYearly: null,
      stripePriceIdMonthly: null,
      stripePriceIdYearly: null,
      maxProducts: 5,
      maxCategories: 3,
      maxLanguages: 1,
      aiCreditsMonthly: 0,
      trialDays: 7,
      allowCustomDomain: false,
      allowQrDownload: true,
      sortOrder: 1,
    },
    {
      name: 'basic',
      displayName: 'Basic',
      priceMonthly: 9.99,
      priceYearly: 99.99,
      stripePriceIdMonthly: process.env.STRIPE_PRICE_ID_BASIC_MONTHLY || 'price_basic_monthly',
      stripePriceIdYearly: process.env.STRIPE_PRICE_ID_BASIC_YEARLY || 'price_basic_yearly',
      maxProducts: 50,
      maxCategories: 10,
      maxLanguages: 1,
      aiCreditsMonthly: 20,
      trialDays: null,
      allowCustomDomain: false,
      allowQrDownload: true,
      sortOrder: 2,
    },
    {
      name: 'pro',
      displayName: 'Pro',
      priceMonthly: 24.99,
      priceYearly: 249.99,
      stripePriceIdMonthly: process.env.STRIPE_PRICE_ID_PRO_MONTHLY || 'price_pro_monthly',
      stripePriceIdYearly: process.env.STRIPE_PRICE_ID_PRO_YEARLY || 'price_pro_yearly',
      maxProducts: 300,
      maxCategories: 50,
      maxLanguages: 3,
      aiCreditsMonthly: 100,
      aiCreditsPerCall: 1,
      allowCustomDomain: true,
      allowQrDownload: true,
      sortOrder: 3,
    },
    {
      name: 'enterprise',
      displayName: 'Enterprise',
      priceMonthly: null,
      priceYearly: null,
      stripePriceIdMonthly: null,
      stripePriceIdYearly: null,
      maxProducts: 999999,
      maxCategories: 999999,
      maxLanguages: 10,
      aiCreditsMonthly: 500,
      aiCreditsPerCall: 1,
      allowCustomDomain: true,
      allowQrDownload: true,
      sortOrder: 4,
    },
  ];

  for (const plan of plans) {
    await prisma.plan.upsert({
      where: { name: plan.name },
      update: {},
      create: plan as any,
    });
  }

  console.log('✅ Plans seeded');
}

seedPlans()
  .catch((e) => {
    console.error('❌ Seed plans error:', e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });